---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：21-インターセプトルート（Intercepting Routes）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15**：NEXT_URLヘッダーの偽装防止に関する具体的検証ロジックの根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/shared/lib/router/utils/interception-routes.ts` - マーカー定数と解析ロジック
- E-02: `packages/next/src/lib/generate-interception-routes-rewrites.ts` - リライトルール生成
- E-03: `packages/next/src/lib/generate-interception-routes-rewrites.test.ts` - テストファイル
- E-04: `packages/next/src/shared/lib/router/utils/route-regex.ts` - 正規表現生成
- E-05: `packages/next/src/client/components/app-router-headers.ts` - NEXT_URLヘッダー定数
- E-06: `packages/next/src/client/components/router-reducer/fetch-server-response.ts` - NEXT_URLヘッダー送信
- E-07: `packages/next/src/client/components/router-reducer/reducers/has-interception-route-in-current-tree.ts` - クライアントサイド検出
- E-08: `packages/next/src/shared/lib/router/utils/app-paths.ts` - normalizeAppPath
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INTERCEPTION_ROUTE_MARKERSは(..)(..),(.),(..),(...)の順で定義 | E-01 (4-9行目) | ○ |
| C-02 | isInterceptionRouteAppPathでセグメントのプレフィックスマッチ | E-01 (13-22行目) | ○ |
| C-03 | extractInterceptionRouteInformationでマーカー位置でパス分割 | E-01 (39-108行目) | ○ |
| C-04 | (.)マーカーは同階層のルートをインターセプト | E-01 (63-70行目) | ○ |
| C-05 | (..)マーカーは1階層上でマッチ、ルートレベルではエラー | E-01 (71-83行目) | ○ |
| C-06 | (...)マーカーはルートからマッチ | E-01 (84-87行目) | ○ |
| C-07 | (..)(..)マーカーは2階層上でマッチ | E-01 (88-102行目) | ○ |
| C-08 | normalizeAppPathでRoute Groupsを除外 | E-01 (60行目), E-08 | ○ |
| C-09 | generateInterceptionRoutesRewritesでリライトルール生成 | E-02 (10-61行目) | ○ |
| C-10 | リライトにNEXT_URLヘッダーのhas条件を設定 | E-02 (48-54行目), E-05 | ○ |
| C-11 | getNamedRouteRegexで正規表現を生成 | E-02 (21-33行目), E-04 | ○ |
| C-12 | ヘッダー正規表現からアンカーを除去 | E-02 (38-43行目) | ○ |
| C-13 | isInterceptionRouteRewriteでNEXT_URLキーチェック | E-02 (63-66行目) | ○ |
| C-14 | クライアントサイドでインターセプトルート検出 | E-06, E-07 | ○ |
| C-15 | NEXT_URLヘッダーの外部からの偽装防止 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- NEXT_URLヘッダーの偽装防止に関する具体的な検証ロジックの実装箇所が未確認
  - 候補：`packages/next/src/server/base-server.ts` / `packages/next/src/server/lib/router-server.ts` / ミドルウェア処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - マーカー解析ロジックは明確にソースコードで確認済み
- 0: 低リスク - リライトルール生成はテストファイルでも検証済み
- 1: 中リスク - セキュリティ考慮事項のNEXT_URLヘッダー偽装防止の根拠要確認

## 6) レビュアーチェックリスト（最小）
- [ ] INTERCEPTION_ROUTE_MARKERSの順序と優先度が正しいか確認
- [ ] 各マーカーのinterceptedRoute算出ロジックが実装と一致するか確認
- [ ] NEXT_URLヘッダーのセキュリティ検証ロジックの有無を確認
